/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;
import net.puffish.skillsmod.api.utils.failure.SingleFailure;

public class PackConfig {
    private final List<String> categories;

    private PackConfig(List<String> categories) {
        this.categories = categories;
    }

    public static Result<PackConfig, Failure> parse(String name, JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(rootObject -> PackConfig.parse(name, rootObject));
    }

    public static Result<PackConfig, Failure> parse(String name, JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Integer version = rootObject.getInt("version").getSuccessOrElse(e -> Integer.MIN_VALUE);
        if (version < 1) {
            return Result.failure(SingleFailure.of("Data pack `" + name + "` is outdated. Check out the mod's wiki to learn how to update the data pack."));
        }
        if (version > 1) {
            return Result.failure(SingleFailure.of("Data pack `" + name + "` is for a newer version of the mod. Please update the mod."));
        }
        Optional optCategories = rootObject.getArray("categories").andThen(array -> array.getAsList((i, element) -> JsonParseUtils.parseIdentifierPath(element)).mapFailure(ManyFailures::ofList)).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new PackConfig((List)optCategories.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    public List<String> getCategories() {
        return this.categories;
    }
}

